* THIS DO-FILE IS FOR THE HISTORICAL PANEL DATA ANALYSIS 
* IT CREATES THE OUTPUT FOR TABLE 3 AND APPENDIX TABLES C1, C2, C3, C4, C5, C7, C8,


use data\urbanflexible.dta, clear




*________________________________________________
*	Table 3: Western Church Exposure and Communes: Panel Data Estimates

*Table 3, Panel 1
preserve
keep if sample10K==1
local v bo_commune exposure
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le10_ bo_citypop_le10_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\Table3_Panel_1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

* Table 3, Panel 2 (Extended ban)
preserve
keep if sample10K==1
local v bo_commune exposure exposure_eb
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le10_ bo_citypop_le10_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\Table3_Panel_2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

*_______________________________________________
*	Table C1: Descriptive statistic of panel data set on Church exposure and Communes
preserve
keep if sample10K==1
gen treat = 0 if exposure==0
replace treat = 1 if exposure>0 & exposure!=.
table year, c(sum bo_citypop_le10_)
table year treat, c(sum bo_citypop_le10_)
*calcuate fraction 
bys year: egen urban_pop = sum(bo_citypop_le10_)
replace  urban_pop= urban_pop/1000
bys year: egen urban_pop_christ = sum(bo_citypop_le10_) if exposure>0 & exposure!=.
replace  urban_pop_christ= urban_pop_christ/1000
bys year: egen communes_no = sum(bo_commune)
bys year: egen mean_exp = mean(exposure)
*bys year: egen mean_exp_Christ = mean(exposure) if exposure>0
gen urban_pop_frac_christ = urban_pop_christ/urban_pop
gen city_ex = 1 if bo_citypop_le10_>0 //city exists
bys year: egen city_no = sum(city_ex) //number of existing cities
bys year: egen city_no_Christ = sum(city_ex) if exposure>0 & exposure!=.
gen commune_frac = communes_no/city_no //percentage of communes among existing cities
*gen commune_frac_Christ = communes_no/city_no_Christ
collapse city_n* communes_no commune_frac  urban_pop*  mean_ex*, by(year)
order year
gen frac_christian_cities = city_no_Christ/city_no
order year city_no city_no_Christ frac_christian_cities urban_pop urban_pop_christ urban_pop_frac_christ communes_no commune_frac mean_exp
outsheet using tables\TableC1_descriptives.xls, replace
restore


*_________________________________________________________________________________
* Table C2: Western Church Exposure and Communes: 
*			Panel Data Estimates with spatial Conley standard errors
*Panel 1
preserve
keep if sample10K==1
forvalues i=500(2000)2500 {
local dist `i'
eststo: acreg bo_commune exposure bo_plundered, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered bo_seariver_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered caloric_suit_100_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered bo_roman_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered Europe_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered BandAB bo_ever_bishop_* , id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered bo_citypop_le10_ bo_citypop_le10_lag, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure bo_plundered bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
esttab using tables\TableC2_Panel_1_Conley_`i'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
}
restore

*Panel 2
preserve
keep if sample10K==1
forvalues i=500(2000)2500 {
local dist `i'
eststo: acreg bo_commune exposure exposure_eb bo_plundered, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered bo_seariver_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered caloric_suit_100_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered bo_roman_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered Europe_*, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered BandAB bo_ever_bishop_* , id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered bo_citypop_le10_ bo_citypop_le10_lag, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
eststo: acreg bo_commune exposure exposure_eb bo_plundered bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, id(cellID) time(year) spatial bartlett latitude(latitude) longitude(longitude) pfe1(cellID) pfe2(year) dist(`i')
esttab using tables\TableC2_Panel_2_Conley_`i'.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
}
restore


*_______________________________________________________________________________
*	Table C3: Church exposure & communes: Iberian Peninsula, Carolingian Emp. & Roman Britain

* Panel 1: Hispanic Penninsula
preserve
keep if sample10K==1
local v bo_commune exposure_s exposure_ns
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le10_ bo_citypop_le10_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC3_Panel_1_Iberia.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

* Panel 2: Carolingian Empire
preserve
keep if sample10K==1
local v bo_commune exposure_c exposure_nc
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le10_ bo_citypop_le10_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC3_Panel_2_Carolingian.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

* Panel 3: Roman Britain
preserve
keep if sample10K==1
local v bo_commune exposure_rb exposure_nrb
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le10_ bo_citypop_le10_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC3_Panel_3_RomainBrittain.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore


*________________________________________________________________________________________
* Table C4: Western Church Exposure and Inclusive City Institutions in the HRE*Panel 1
preserve
keep if sampleHRE==1
local v fw_InclusiveInst exposure
xi: areg `v' i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year*caro, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le5_ bo_citypop_le5_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* BandAB bo_ever_bishop_* bo_citypop_le5_ bo_citypop_le5_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC4_Panel_1.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

*Panel 2
preserve
keep if sampleHRE==1
local v fw_InclusiveInst exposure
keep if northgerm==1
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year*caro, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_citypop_le5_ bo_citypop_le5_lag i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* BandAB bo_ever_bishop_* bo_citypop_le5_ bo_citypop_le5_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC4_Panel_2.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore


*_______________________________________________________________________________
* Table C5: Western Church Exposure and City population: Panel Data Estimates 
preserve
keep if sample10K==1
local v bo_citypop_le10_ exposure
eststo: xi: areg `v' bo_plundered i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered BandAB i.year bo_ever_bishop_*, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered bo_commune bo_commune_lag1 i.year, absorb(cellID) cluster(cellID)
eststo: xi: areg `v' bo_plundered i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* BandAB bo_ever_bishop_* bo_commune bo_commune_lag1, absorb(cellID) cluster(cellID)
esttab using tables\TableC5_population.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore



*_______________________________________________________________________________
*	Table C7: Western Church Exposure and Commune Cities: Event study - Specification (3)

preserve
keep if sample10K==1
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year, absorb(cellID) cluster(cellID)
test aw_m3_ = aw_m2_ = aw_m1_ = 0
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year bo_seariver_*, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year bo_roman_*, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year Europe_*, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year bo_ever_bishop_* BandAB, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_  aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* bo_ever_bishop_* BandAB bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
test aw_m1_ = aw_0_
esttab using tables\TableC7_EventStudy.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore

*_______________________________________________________________________________
*	Table C8: Western Church Exposure and Commune Cities: Event study Specification (4)
preserve
keep if sample10K==1
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year, absorb(cellID) cluster(cellID)
test aw_m3_ = aw_m2_ = aw_m1_ = 0
test aw_m_eb3_ = aw_m_eb2_ = aw_m_eb1_ = 0
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year bo_seariver_*, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year caloric_suit_100_*, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year bo_roman_*, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year Europe_*, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year bo_ever_bishop_* BandAB, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
eststo: xi: areg bo_commune bo_plundered aw_m3_ aw_m2_ aw_m1_ aw_0_ aw_1_ aw_2_ aw_3_ aw_4_ aw_5_ aw_6_ aw_7_ aw_8_ aw_9_ aw_m_eb3_ aw_m_eb2_ aw_m_eb1_ aw_eb0_ aw_eb1_ aw_eb2_  aw_eb3_  aw_eb4_  aw_eb5_  aw_eb6_ aw_eb7_  aw_eb8_  aw_eb9_  i.year bo_seariver_* caloric_suit_100_* bo_roman_* Europe_* bo_ever_bishop_* BandAB bo_citypop_le10_ bo_citypop_le10_lag, absorb(cellID) cluster(cellID)
esttab using tables\TableC8_EventStudy.rtf, replace star(* 0.10 ** 0.05 *** 0.01) se cells(b(star fmt(3)) se(par fmt(3))) scalars(r2)
eststo clear
restore
